
// AWC ASH Axon Data Acquisition Script 
// Used with ImageJ 64-bit 1.49k Mac OS X 10.9.5
// Donovan Ventimiglia
// June, 2017


// Movement_Correction

macro "Movement_Correction [q]" {

dir = getDirectory("Choose a Directory ");
list = getFileList(dir);


//Filter out files that are not tiffs

k=0;
newlist = newArray(list.length);

for (i=0; i < list.length; i++)  {
	if (endsWith(list[i], ".tif")) {
	newlist[k] = list[i];
	k=k+1;
	}
}
list = Array.trim(newlist, k)

//Specify which file to began Alignment on

numberOfMovieFiles=list.length;
Files=getNumber("found "+numberOfMovieFiles+" files, at what movie do you want to start tracking?", 0);
startFile=startFile;

// Start Alignment

setBatchMode(true);

for (startFile=0; Files < list.length; Files++)  {
open(dir + list[Files]);

name = getTitle;
output=getInfo("image.directory");
n=nSlices; 
dotIndex = indexOf(name, "."); 
title = substring(name, 0, dotIndex); 
run("Duplicate...", "title=stack duplicate range=1-n");

//Position Image Window
 script =
   "lw = WindowManager.getFrame( 'stack' );\n"+
   "if (lw!=null) {\n"+
   "   lw.setLocation(900,400);\n"+
   "}\n";
 eval("script", script);
run("In [+]");

//Auto-draw rectangle

X=getWidth();
Y=getHeight();

makeRectangle(floor(X/4), 0, floor(X/1.8), Y);

getSelectionBounds(x, y, w, h);

//Runs Align slices plugin (from template matching), using ROI specified by the rectangle above

run("Align slices in stack...", "method=5 windowsizex="+w+" windowsizey="+h+" x0="+x+" y0="+y+" swindow=0 subpixel=false ref.slice=1 show=true");

selectWindow("stack");

if (File.exists(dir+"/Registered Tiffs/")==0){

File.makeDirectory(dir+"/Registered Tiffs/");

}

if (File.exists(dir+"/Registered Tiffs/Tracks/")==0){

File.makeDirectory(dir+"/Registered Tiffs/Tracks/");

}

selectWindow("Results");
saveAs("txt", dir+"/Registered Tiffs/Tracks/"+"Registered"+title+"MovementRecord");


selectWindow("stack");
run("Select None");
saveAs("Tiff",dir+"/Registered Tiffs/"+"Registered"+title);

{
      while (nImages>0) { 
          selectImage(nImages); 
          close(); 
      }
}

selectWindow("Log");
run("Close");

selectWindow("Results");
run("Close");


} // end file open loop


setBatchMode('false');

} // end script

//-----------------------------------------------------------------------------------------------------------------------------------

// Data Acquisition Script -Movement_Correction checking script

// Donovan Ventimiglia

// Feb 11, 2014

macro "Movement_Correction Check [Q]" {

dir = getDirectory("Choose a Directory ");
dir_Registered=dir+"/Registered Tiffs/";
list = getFileList(dir_Registered);


//Filter out files that are not tiffs

k=0;
newlist = newArray(list.length);

for (i=0; i < list.length; i++)  {
	if (endsWith(list[i], ".tif")) {
	newlist[k] = list[i];
	k=k+1;
	}
}
list = Array.trim(newlist, k)

// Store a list of files that cannot be accurrately tracked
Dont_Track=newArray(list.length);

//Specify start movie.

numberOfMovieFiles=list.length;
Files=getNumber("found "+numberOfMovieFiles+" files, at what movie do you want to start tracking?", 0);
startFile=startFile;

// Start at movie 0.
//numberOfMovieFiles=list.length;
//Files=0;
//startFile=startFile;


// Open files and check for correct alignment


for (startFile=0; Files < list.length; Files++)  {
open(dir+"/Registered Tiffs/" + list[Files]);

name = getTitle;
output=getInfo("image.directory");
n=nSlices; 
dotIndex = indexOf(name, "."); 
title = substring(name, 0, dotIndex); 

//Position Image Window
 script =
   "lw = WindowManager.getFrame( 'stack' );\n"+
   "if (lw!=null) {\n"+
   "   lw.setLocation(900,400);\n"+
   "}\n";
 eval("script", script);


// Allows time for user to scroll through movie.

setKeyDown("none");
showStatus("Check for Movement!");
wait(1000);
do {

	setTool("rectangle");
	wait(100);
	} while (isKeyDown("space") != 1);

wait(100);

//Create Dialog box for user input


Dialog.create("Is the movement corrected?");
Dialog.addChoice("Yes or No:" , newArray("yes","no"));
Dialog.addCheckbox("Okay for tracking?", true);
Dialog.show();
Track_it=Dialog.getCheckbox();
choice=Dialog.getChoice();

//Allows user to redo registration if alignment is unsuccessful.


if (choice=="No") { 

do {
selectWindow(title+".tif");
close();
OrignialFileName=substring(name, 10);
open(dir+OrignialFileName);

run("Duplicate...", "title=stack duplicate range=1-n");

 script =
   "lw = WindowManager.getFrame( 'stack' );\n"+
   "if (lw!=null) {\n"+
   "   lw.setLocation(900,400);\n"+
   "}\n";
 eval("script", script);


wait(1000);
do {

	setTool("rectangle");
      
	wait(100);
	} while (isKeyDown("space") != 1);

wait(100);

getSelectionBounds(x, y, w, h);
run("Align slices in stack...", "method=5 windowsizex="+w+" windowsizey="+h+" x0="+x+" y0="+y+" swindow=0 subpixel=false ref.slice=1 show=true");


showStatus("Check for Movement");
wait(1000);
do {

	wait(100);
	} while (isKeyDown("space") != 1);

wait(100);

Dialog.create("Is the movement corrected?");
Dialog.addChoice("Yes or No:" , newArray("yes","no"));
Dialog.addCheckbox("Okay for tracking?", true);
Dialog.show();
Track_it=Dialog.getCheckbox();
choice=Dialog.getChoice();

//Loop allowing user to redo registration if, again, alignment is unsuccessful.

if (choice=="No"){ 

do {
selectWindow("stack");
close();
selectWindow(OrignialFileName);
run("Duplicate...", "title=stack duplicate range=1-n");

 script =
   "lw = WindowManager.getFrame( 'stack' );\n"+
   "if (lw!=null) {\n"+
   "   lw.setLocation(900,400);\n"+
   "}\n";
 eval("script", script);


wait(1000);
do {

	setTool("rectangle");
      
	wait(100);
	} while (isKeyDown("space") != 1);

wait(100);

getSelectionBounds(x, y, w, h);
run("Align slices in stack...", "method=5 windowsizex="+w+" windowsizey="+h+" x0="+x+" y0="+y+" swindow=0 ref.slice=1 show=true");


showStatus("Check for Movement");
wait(1000);
do {

	wait(100);
	} while (isKeyDown("space") != 1);

wait(100);

Dialog.create("Is the movement corrected?");
Dialog.addChoice("Yes or No:" , newArray("yes","no"));
Dialog.addCheckbox("Okay for tracking?", true);
Dialog.show();
Track_it=Dialog.getCheckbox();
choice=Dialog.getChoice(); } while(choice=="No");


}


selectWindow("Results");
saveAs("txt", dir+"/Registered Tiffs/Tracks/"+title+"MovementRecord");


selectWindow("stack");
saveAs("Tiff",dir+"/Registered Tiffs/"+title);

selectWindow("Log");
run("Close");

selectWindow("Results");
run("Close");

}

while(choice=="No"); }


// log names of files not to track
if (Track_it==0) {

Dont_Track[Files]=title;
}

close();

{
      while (nImages>0) { 
          selectImage(nImages); 
          close(); 
      }
}



} //end  for (file=0; file < list.length; file++)

for (file=0; file <list.length; file++) {
	print(Dont_Track[file]); }


selectWindow("Log");
saveAs("txt", dir+"/Registered Tiffs/List_of_untrackables");
selectWindow("Log");
run("Close");

}


//-----------------------------------------------------------------------------------------------------------------------------------
// Data Acquisition - Acquires whole axon mean FL in each frame. Also acquires ROI data along axon (length of 8 y-pixels/ROI) and local background.
// Donovan Ventimgilia
// 03/04/2015


macro "Data_Acquisition [t]" {

// Choose folder of registered files.

dir = getDirectory("Choose a Directory ");
list = getFileList(dir);
k=0;
newlist = newArray(list.length);

for (i=0; i < list.length; i++)  {
	if (startsWith(list[i], "Registered")) {
	newlist[k] = list[i];
	k=k+1;
	}
}
list = Array.trim(newlist, k)

numberOfMovieFiles=list.length;
Files=getNumber("found "+numberOfMovieFiles+" files, at what movie do you want to start tracking?", 0);
startFile=startFile;

// Create folders for storing data

if (File.exists(dir+"/Data/")==0){

File.makeDirectory(dir+"/Data/");

}

if (File.exists(dir+"/ROI Positions/")==0){

File.makeDirectory(dir+"/ROI Positions/");

}

// Start acquisition. Loop for each tiff in directory
for (startFile=0; Files < list.length; Files++)  {
	open(dir + list[Files]);
	
	name = getTitle;
	output=getInfo("image.directory");
	n=nSlices; 
	dotIndex = indexOf(name, "."); 
	title = substring(name, 0, dotIndex); 
	
	//Select region of video containing axon and relevent background

	//Set Image Window Location
	//script ="lw = WindowManager.getFrame(name);\n"+"if (lw!=null) {\n"+"lw.setLocation(750,400);\n"+"}\n"; eval("script", script);
	
	
	print("Select region containing only axon");
	
	wait(1000);
	do {
	
		setTool("rectangle");
		wait(100);
		} while (isKeyDown("space") != 1);
	
	wait(100);
	getSelectionBounds(crop_x, crop_y, crop_w, crop_h); // for storing the region selected
	run("Duplicate...", "title=filtered duplicate range=1-n");
	selectWindow(name);
	run("Duplicate...", "title=RAW duplicate range=1-n");
	selectWindow("Log"); 
	run("Close");
	
	
	// Create imaging for selecting threshold
	
	selectWindow("filtered");
	run("Z Project...", "start=1 stop=n projection=[Average Intensity]");
	run("Subtract Background...", "rolling=10 stack");
	run("In [+]");run("In [+]");run("In [+]");

	//Set Image Window Location
	script ="lw = WindowManager.getFrame('AVG_filtered');\n"+"if (lw!=null) {\n"+"lw.setLocation(750,400);\n"+"}\n"; eval("script", script);
	
	// select threshold
	print("Select axon threshold");
	selectWindow("AVG_filtered");
	run("Threshold...");
	setThreshold(30,65535);

	
	
		do {
			getThreshold(lower, upper);
			test=isKeyDown("alt");
			} while (isKeyDown("space") != 1);
	setThreshold(lower, 65535);
	wait(100);
	selectWindow("Log"); 
	run("Close");
	
	// Store threshold
	Threshold=lower;

	// Allows user to hand-draw ROI if thresholding is problematic
			if (test != 1 ) {
		
			
			// Create axon ROI 
			selectWindow("AVG_filtered");
			roiManager("Reset");
			run("Analyze Particles...", "size=100-Infinity circularity=0.0-1 clear add");
			roiManager("Show None");
			run("Remove Overlay");
			run("Clear Results");
			selectWindow("RAW");
			roiManager("Select", 0);
			getSelectionCoordinates(axonX, axonY); // store axon outline
			
			} else {
					print("Outline Axon");
					selectWindow("AVG_filtered");
					showStatus("Hand Draw ROI");
					wait(1000);
					do {
						setTool("polygon");
						wait(100);
						} while (isKeyDown("space") != 1);
						
					roiManager("Reset");
					roiManager("add");
					selectWindow("RAW");
					roiManager("Select", 0);
					getSelectionCoordinates(axonX, axonY);
					selectWindow("Log"); 
					run("Close");
		 
			} //end draw loop
	
	
	// Axon regions
	//--------------------------------------------------------------------------------------------------------
	
	
	// Measure axon length
	selectWindow("RAW");
	roiManager("Select", 0);
	run("To Bounding Box");
	getSelectionBounds(X, Y, W, Axon_length); //measure axon length
	
	
	// ROI #1
	roiManager("Select", 0);
	setKeyDown("alt");
	makeRectangle(X,Y+8,W,Axon_length-8);
	roiManager("add");
	makeRectangle(X-28,Y,8,8); // BG 1
	roiManager("add");
	makeRectangle(X+6+20,Y,8,8); //BG 2 note: the extra shift of 6 pixels is to account for the ~ width of the axon.
	roiManager("add");
	
	// for ROI #2 through end-1
	for (Seg_Num=1; Seg_Num<floor(Axon_length/8)-1; Seg_Num++) {
	
		selectWindow("RAW");
		roiManager("Select", 0);
		setKeyDown("alt");
		makeRectangle(X,Y,W,8*Seg_Num);
		setKeyDown("alt");
		makeRectangle(X,Y+8*(Seg_Num+1),W,Axon_length-8*(Seg_Num+1));
		roiManager("add");
		
		run("Set Measurements...", "bounding redirect=None decimal=3");
		run("Measure"); bg_x=getResult("BX",0); bg_y=getResult("BY",0); // measure the position of this ROI
		
		makeRectangle(bg_x-28,bg_y,8,8); // BG 1
		roiManager("add");
		makeRectangle(bg_x+6+20,bg_y,8,8); //BG 2
		roiManager("add");
		run("Clear Results");
		
		} //end loop
	
	// Last ROI
	roiManager("Select", 0);
	setKeyDown("alt");
	makeRectangle(X,Y,W,Axon_length-8);
	roiManager("add");
	
	run("Set Measurements...", "bounding redirect=None decimal=3");
	run("Measure"); bg_x=getResult("BX",0); bg_y=getResult("BY",0); // measure the position of this ROI
	
	makeRectangle(bg_x-28,bg_y,8,8); // BG 1
	roiManager("add");
	makeRectangle(bg_x+6+20,bg_y,8,8); //BG 2
	roiManager("add");
	run("Clear Results");
	
	// Get Data from ROIs
	run("Set Measurements...", "area mean standard integrated median redirect=None decimal=3");
	roiManager("deselect");
	selectWindow("RAW");
	roiManager("Multi Measure");
	selectWindow("Results");
	saveAs("Text",dir+"/Data/"+title+"Data");
	run("Close");

	// Save ROI coordinates
 
	print("Box (x,y,w,h) used to crop out axon in registered image");
		print(crop_x+" "+crop_y+" "+crop_w+" "+crop_h);
	print("Axon Threshold");
		print(Threshold);    
	print("Hand drawn ROI?");
		print(test);   
    selectWindow("Log");  
	saveAs("Text",dir+"/ROI Positions/"+title+"Tracksettings"); 
	selectWindow("Log"); 
	run("Close");    

	
	roiManager("deselect");
	selectWindow("ROI Manager");
	roiManager("Save",dir+"/ROI Positions/"+title+"ROIs.zip" );
	
	
	
	// close windows 
	roiManager("Reset");
	selectWindow(name);close();
	selectWindow("RAW");close();
	selectWindow("filtered");close();

	// close any open images
	{
	      while (nImages>0) { 
	          selectImage(nImages); 
	          close(); 
	      }
	}


} // end open file loop

} // end script


